/*
 * Decompiled with CFR 0.152.
 */
package com.uc.crashsdk.export;

public class CustomInfo {
    public String mAppId = "CrashSDK";
    public String mJavaCrashLogFileName = null;
    public String mNativeCrashLogFileName = null;
    public String mUnexpCrashLogFileName = null;
    public String mTagFilesFolderName = "crashsdk/tags";
    public String mCrashLogsFolderName = "crashsdk/logs";
    public String mLogsBackupPathName = null;
    public int mMaxCrashLogFilesCount = 15;
    public int mMaxCustomLogFilesCount = 10;
    public int mMaxJavaLogcatLineCount = 1500;
    public int mMaxNativeLogcatLineCount = 3000;
    public int mMaxUnexpLogcatLineCount = 500;
    public int mUnexpDelayMillSeconds = 60000;
    public int mUnexpSubTypes = 32000;
    public boolean mBackupLogs = false;
    public boolean mUploadUcebuCrashLog = false;
    public boolean mSyncUploadSetupCrashLogs = true;
    public boolean mOmitJavaCrash = false;
    public boolean mOmitNativeCrash = false;
    public boolean mDumpUserSolibBuildId = true;
    public boolean mAutoDeleteOldVersionStats = true;
    public boolean mZipLog = false;
    public String mZippedLogExtension = ".gz";
    public int mLogMaxBytesLimit = 0x100000;
    public int mLogMaxUploadBytesLimit = 819200;
    public long mMaxUploadBytesPerDay = 0x180000L;
    public int mMaxUploadCrashLogCountPerDay = 20;
    public int mMaxUploadCustomLogCountPerDay = 20;
    public int mMaxCustomLogCountPerTypePerDay = 6;
    public int mCrashRestartInterval = -1;
    public boolean mCallJavaDefaultHandler = false;
    public boolean mCallNativeDefaultHandler = false;
    public boolean mDumpHprofDataForJavaOOM = false;
    public boolean mRenameFileToDefaultName = false;
    public int mUnexpInfoUpdateInterval = 180;
    public boolean mOverrideLibcMalloc = false;
    public int mReservedJavaFileHandleCount = 15;
    public int mReservedNativeFileHandleCount = 10;
    public int mFdDumpMinLimit = 900;
    public int mThreadsDumpMinLimit = 300;
    public long mReservedNativeMemoryBytes = 0x300000L;
    public int mDisableSignals = 0;
    public int mDisableBackgroundSignals = 16384;
    public boolean mEnableStatReport = false;
    public boolean mIsInternational = false;
    public boolean mAutoDetectLifeCycle = true;
    public boolean mPrintStackInfos = false;
    public boolean mDebug = false;
    public boolean mIsUsedByUCM = false;
    public String mLogTypeSuffix = null;

    public CustomInfo() {
    }

    public CustomInfo(String string) {
        this.mAppId = string;
    }

    public CustomInfo(String string, boolean bl) {
        this(string);
        this.mBackupLogs = bl;
    }

    public CustomInfo(String string, boolean bl, boolean bl2, boolean bl3) {
        this(string, bl);
        this.mUploadUcebuCrashLog = bl2;
        this.mOverrideLibcMalloc = bl3;
    }

    public CustomInfo(CustomInfo customInfo) {
        this.mAppId = customInfo.mAppId;
        this.mJavaCrashLogFileName = customInfo.mJavaCrashLogFileName;
        this.mNativeCrashLogFileName = customInfo.mNativeCrashLogFileName;
        this.mUnexpCrashLogFileName = customInfo.mUnexpCrashLogFileName;
        this.mTagFilesFolderName = customInfo.mTagFilesFolderName;
        this.mCrashLogsFolderName = customInfo.mCrashLogsFolderName;
        this.mLogsBackupPathName = customInfo.mLogsBackupPathName;
        this.mMaxCrashLogFilesCount = customInfo.mMaxCrashLogFilesCount;
        this.mMaxCustomLogFilesCount = customInfo.mMaxCustomLogFilesCount;
        this.mMaxJavaLogcatLineCount = customInfo.mMaxJavaLogcatLineCount;
        this.mMaxNativeLogcatLineCount = customInfo.mMaxNativeLogcatLineCount;
        this.mMaxUnexpLogcatLineCount = customInfo.mMaxUnexpLogcatLineCount;
        this.mUnexpDelayMillSeconds = customInfo.mUnexpDelayMillSeconds;
        this.mUnexpSubTypes = customInfo.mUnexpSubTypes;
        this.mBackupLogs = customInfo.mBackupLogs;
        this.mUploadUcebuCrashLog = customInfo.mUploadUcebuCrashLog;
        this.mSyncUploadSetupCrashLogs = customInfo.mSyncUploadSetupCrashLogs;
        this.mOmitJavaCrash = customInfo.mOmitJavaCrash;
        this.mOmitNativeCrash = customInfo.mOmitNativeCrash;
        this.mDumpUserSolibBuildId = customInfo.mDumpUserSolibBuildId;
        this.mAutoDeleteOldVersionStats = customInfo.mAutoDeleteOldVersionStats;
        this.mZipLog = customInfo.mZipLog;
        this.mZippedLogExtension = customInfo.mZippedLogExtension;
        this.mLogMaxBytesLimit = customInfo.mLogMaxBytesLimit;
        this.mLogMaxUploadBytesLimit = customInfo.mLogMaxUploadBytesLimit;
        this.mMaxUploadBytesPerDay = customInfo.mMaxUploadBytesPerDay;
        this.mMaxUploadCrashLogCountPerDay = customInfo.mMaxUploadCrashLogCountPerDay;
        this.mMaxUploadCustomLogCountPerDay = customInfo.mMaxUploadCustomLogCountPerDay;
        this.mMaxCustomLogCountPerTypePerDay = customInfo.mMaxCustomLogCountPerTypePerDay;
        this.mCrashRestartInterval = customInfo.mCrashRestartInterval;
        this.mCallJavaDefaultHandler = customInfo.mCallJavaDefaultHandler;
        this.mCallNativeDefaultHandler = customInfo.mCallNativeDefaultHandler;
        this.mDumpHprofDataForJavaOOM = customInfo.mDumpHprofDataForJavaOOM;
        this.mRenameFileToDefaultName = customInfo.mRenameFileToDefaultName;
        this.mUnexpInfoUpdateInterval = customInfo.mUnexpInfoUpdateInterval;
        this.mOverrideLibcMalloc = customInfo.mOverrideLibcMalloc;
        this.mReservedJavaFileHandleCount = customInfo.mReservedJavaFileHandleCount;
        this.mReservedNativeFileHandleCount = customInfo.mReservedNativeFileHandleCount;
        this.mFdDumpMinLimit = customInfo.mFdDumpMinLimit;
        this.mThreadsDumpMinLimit = customInfo.mThreadsDumpMinLimit;
        this.mReservedNativeMemoryBytes = customInfo.mReservedNativeMemoryBytes;
        this.mDisableSignals = customInfo.mDisableSignals;
        this.mDisableBackgroundSignals = customInfo.mDisableBackgroundSignals;
        this.mEnableStatReport = customInfo.mEnableStatReport;
        this.mIsInternational = customInfo.mIsInternational;
        this.mAutoDetectLifeCycle = customInfo.mAutoDetectLifeCycle;
        this.mPrintStackInfos = customInfo.mPrintStackInfos;
        this.mDebug = customInfo.mDebug;
        this.mIsUsedByUCM = customInfo.mIsUsedByUCM;
        this.mLogTypeSuffix = customInfo.mLogTypeSuffix;
    }
}

