/*
 * Decompiled with CFR 0.152.
 */
package com.uc.crashsdk.export;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.webkit.ValueCallback;
import com.uc.crashsdk.CrashLogFilesUploader;
import com.uc.crashsdk.JNIBridge;
import com.uc.crashsdk.a;
import com.uc.crashsdk.a.g;
import com.uc.crashsdk.b;
import com.uc.crashsdk.d;
import com.uc.crashsdk.e;
import com.uc.crashsdk.export.CustomInfo;
import com.uc.crashsdk.export.CustomLogInfo;
import com.uc.crashsdk.export.DumpFileInfo;
import com.uc.crashsdk.export.ICrashClient;
import com.uc.crashsdk.export.LogType;
import com.uc.crashsdk.export.VersionInfo;
import com.uc.crashsdk.h;
import com.uc.crashsdk.i;
import java.util.concurrent.Callable;

public class CrashApi {
    private static CrashApi a = null;
    private boolean b = false;
    private boolean c = false;
    private static boolean d = false;

    public static synchronized CrashApi createInstance(Context context, CustomInfo customInfo, VersionInfo versionInfo, ICrashClient iCrashClient, String string, boolean bl, boolean bl2, boolean bl3) {
        if (a == null) {
            a = new CrashApi(context, customInfo, versionInfo, iCrashClient, string, bl, bl2, bl3);
        }
        return a;
    }

    public static CrashApi createInstance(Context context, CustomInfo customInfo, VersionInfo versionInfo, ICrashClient iCrashClient, String string) {
        return CrashApi.createInstance(context, customInfo, versionInfo, iCrashClient, string, true, true, true);
    }

    public static CrashApi createInstance(Context context, CustomInfo customInfo, VersionInfo versionInfo, String string) {
        return CrashApi.createInstance(context, customInfo, versionInfo, null, string);
    }

    public static CrashApi createInstance(Context context, String string, Bundle bundle) {
        return CrashApi.createInstance(context, string, bundle, null, null);
    }

    public static CrashApi createInstance(Context context, String string, Bundle bundle, ValueCallback<Bundle> valueCallback, ValueCallback<Bundle> valueCallback2) {
        String string2;
        if (a != null) {
            return a;
        }
        if (bundle == null) {
            throw new NullPointerException();
        }
        CrashApi.a(context);
        CustomInfo customInfo = h.a(null, bundle);
        VersionInfo versionInfo = h.a(bundle);
        boolean bl = bundle.getBoolean("enableJavaLog", true);
        boolean bl2 = bundle.getBoolean("enableNativeLog", true);
        boolean bl3 = bundle.getBoolean("enableUnexpLog", com.uc.crashsdk.b.A());
        CrashApi crashApi = CrashApi.createInstance(context, customInfo, versionInfo, null, string, bl, bl2, bl3);
        if (valueCallback != null) {
            com.uc.crashsdk.d.d(valueCallback);
        }
        if (valueCallback2 != null) {
            com.uc.crashsdk.d.a(valueCallback2);
        }
        if (g.b(string2 = bundle.getString("soPathName")) && e.e(string2)) {
            crashApi.crashSoLoaded();
        }
        return crashApi;
    }

    public static CrashApi createInstanceEx(Context context, String string, boolean bl) {
        return CrashApi.createInstanceEx(context, string, bl, null);
    }

    public static CrashApi createInstanceEx(Context context, String string, boolean bl, Bundle bundle) {
        return CrashApi.createInstanceEx(context, string, bl, bundle, null);
    }

    public static CrashApi createInstanceEx(Context context, String string, boolean bl, Bundle bundle, ICrashClient iCrashClient) {
        int n;
        if (a != null) {
            return a;
        }
        CrashApi.a(context);
        if (bundle == null) {
            bundle = new Bundle();
        }
        CustomInfo customInfo = new CustomInfo(string);
        new CustomInfo(string).mEnableStatReport = true;
        customInfo.mZipLog = true;
        customInfo.mPrintStackInfos = bl;
        customInfo = h.a(customInfo, bundle);
        VersionInfo versionInfo = h.a(bundle);
        boolean bl2 = bundle.getBoolean("enableJavaLog", true);
        boolean bl3 = bundle.getBoolean("enableNativeLog", true);
        boolean bl4 = bundle.getBoolean("enableUnexpLog", com.uc.crashsdk.b.A());
        CrashApi crashApi = CrashApi.createInstance(context, customInfo, versionInfo, iCrashClient, e.t(), bl2, bl3, bl4);
        if (bl3 || bl4) {
            if (e.f("libcrashsdk.so")) {
                crashApi.crashSoLoaded();
            } else {
                com.uc.crashsdk.a.a.b("crashsdk", "load libcrashsdk.so failed!");
            }
        }
        if ((n = bundle.getInt("uploadLogDelaySeconds", 15)) >= 0 && com.uc.crashsdk.b.A()) {
            e.b(n);
        }
        return crashApi;
    }

    public boolean registerCallback(int n, ValueCallback<Bundle> valueCallback) {
        if (valueCallback == null) {
            throw new NullPointerException();
        }
        switch (n) {
            case 1: {
                return com.uc.crashsdk.d.a(valueCallback);
            }
            case 2: {
                return com.uc.crashsdk.d.c(valueCallback);
            }
            case 3: {
                return com.uc.crashsdk.d.d(valueCallback);
            }
            case 4: {
                return com.uc.crashsdk.d.b(valueCallback);
            }
        }
        throw new IllegalArgumentException("Unknown event type: " + n);
    }

    public int updateCustomInfo(CustomInfo customInfo) {
        if (customInfo == null) {
            throw new NullPointerException();
        }
        return h.b(customInfo);
    }

    public int updateCustomInfo(Bundle bundle) {
        if (bundle == null) {
            throw new NullPointerException();
        }
        CustomInfo customInfo = h.a(null, bundle);
        return this.updateCustomInfo(customInfo);
    }

    public static CrashApi getInstance() {
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void crashSoLoaded() {
        if (CrashApi.a("crashSoLoaded")) {
            return;
        }
        com.uc.crashsdk.b.f = true;
        this.b();
        Object object = com.uc.crashsdk.b.e;
        synchronized (object) {
            if (!com.uc.crashsdk.b.g || !com.uc.crashsdk.b.f) {
            } else if (!com.uc.crashsdk.b.c) {
                if (!com.uc.crashsdk.b.d) {
                    CrashApi.c();
                    h.e();
                }
                e.q();
                com.uc.crashsdk.b.c = true;
            }
        }
        com.uc.crashsdk.a.m();
        e.i();
    }

    public void updateVersionInfo(VersionInfo versionInfo) {
        if (versionInfo == null) {
            throw new NullPointerException();
        }
        h.a(versionInfo);
    }

    public void updateVersionInfo(Bundle bundle) {
        if (bundle == null) {
            throw new NullPointerException();
        }
        VersionInfo versionInfo = h.a(bundle);
        this.updateVersionInfo(versionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableLog(int n) {
        Object object = com.uc.crashsdk.b.e;
        synchronized (object) {
            com.uc.crashsdk.b.b(n);
            if (LogType.isForJava(n) && com.uc.crashsdk.b.a) {
                e.o();
                com.uc.crashsdk.b.a = false;
            }
            if (LogType.isForNative(n)) {
                if (com.uc.crashsdk.b.b) {
                    JNIBridge.nativeUninstallBreakpad();
                    com.uc.crashsdk.b.b = false;
                } else {
                    this.b = false;
                }
            }
            if (LogType.isForUnexp(n)) {
                if (com.uc.crashsdk.b.c) {
                    if (e.s()) {
                        com.uc.crashsdk.b.c = false;
                    }
                } else {
                    com.uc.crashsdk.b.g = false;
                }
            }
            return;
        }
    }

    public boolean addStatInfo(String string, String string2) {
        if (CrashApi.a("addStatInfo")) {
            return false;
        }
        if (g.a(string)) {
            throw new NullPointerException();
        }
        if (string.length() > 24) {
            throw new IllegalArgumentException("key is too long!");
        }
        if (string2 != null && string2.length() > 512) {
            string2 = string2.substring(0, 512);
        }
        return com.uc.crashsdk.a.h.a(string, string2);
    }

    public void setCrashLogUploadUrl(String string) {
        if (CrashApi.a("setCrashLogUploadUrl")) {
            return;
        }
        e.a(string, false);
    }

    public String getCrashLogUploadUrl() {
        if (CrashApi.a("getCrashLogUploadUrl")) {
            return null;
        }
        return e.h();
    }

    public int getLastExitType() {
        if (CrashApi.a("getLastExitType")) {
            return 1;
        }
        return com.uc.crashsdk.b.B();
    }

    public int reportCrashStats(boolean bl) {
        if (CrashApi.a("reportCrashStats")) {
            return 0;
        }
        return e.b(bl, true);
    }

    public int resetCrashStats(boolean bl) {
        if (CrashApi.a("resetCrashStats")) {
            return 0;
        }
        return e.c(bl);
    }

    public void onExit() {
        com.uc.crashsdk.b.t();
    }

    public void setNewInstall() {
        if (CrashApi.a("setNewInstall")) {
            return;
        }
        com.uc.crashsdk.b.s();
    }

    public void setForeground(boolean bl) {
        com.uc.crashsdk.b.a(bl);
    }

    public void uploadCrashLogs() {
        if (CrashApi.a("uploadCrashLogs")) {
            return;
        }
        e.a(false, true);
    }

    public int registerThread(int n, String string) {
        return com.uc.crashsdk.a.a(n, string);
    }

    public boolean generateCustomLog(CustomLogInfo customLogInfo) {
        if (customLogInfo == null) {
            throw new NullPointerException();
        }
        if (customLogInfo.mData == null || customLogInfo.mLogType == null) {
            throw new NullPointerException("mData or mLogType is null!");
        }
        if (customLogInfo.mLogType.contains("_") || customLogInfo.mLogType.contains(" ")) {
            throw new IllegalArgumentException("mLogType can not contain char '_' and ' '");
        }
        StringBuilder stringBuilder = null;
        if (customLogInfo.mDumpTids != null && customLogInfo.mDumpTids.size() > 0) {
            stringBuilder = new StringBuilder();
            for (int n : customLogInfo.mDumpTids) {
                stringBuilder.append(n);
                stringBuilder.append(" ");
            }
        }
        return e.a(customLogInfo.mData, customLogInfo.mLogType, customLogInfo.mAddHeader, customLogInfo.mAddFooter, customLogInfo.mAddLogcat, customLogInfo.mAddThreadsDump, customLogInfo.mUploadNow, customLogInfo.mDumpFiles, customLogInfo.mCallbacks, customLogInfo.mCachedInfos, stringBuilder != null ? stringBuilder.toString() : null);
    }

    public boolean generateCustomLog(StringBuffer stringBuffer, String string, Bundle bundle) {
        CustomLogInfo customLogInfo = new CustomLogInfo(stringBuffer, string);
        if (bundle != null) {
            customLogInfo.mAddHeader = bundle.getBoolean("mAddHeader", customLogInfo.mAddHeader);
            customLogInfo.mAddFooter = bundle.getBoolean("mAddFooter", customLogInfo.mAddFooter);
            customLogInfo.mAddLogcat = bundle.getBoolean("mAddLogcat", customLogInfo.mAddLogcat);
            customLogInfo.mUploadNow = bundle.getBoolean("mUploadNow", customLogInfo.mUploadNow);
            customLogInfo.mAddThreadsDump = bundle.getBoolean("mAddThreadsDump", customLogInfo.mAddThreadsDump);
            customLogInfo.mDumpFiles = bundle.getStringArrayList("mDumpFiles");
            customLogInfo.mCallbacks = bundle.getStringArrayList("mCallbacks");
            customLogInfo.mCachedInfos = bundle.getStringArrayList("mCachedInfos");
            customLogInfo.mDumpTids = bundle.getIntegerArrayList("mDumpTids");
        }
        return this.generateCustomLog(customLogInfo);
    }

    public void addHeaderInfo(String string, String string2) {
        if (string == null) {
            throw new NullPointerException();
        }
        com.uc.crashsdk.a.a(string, string2);
    }

    public int createCachedInfo(String string, int n, int n2) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (n <= 0) {
            throw new IllegalArgumentException("capacity must > 0!");
        }
        if ((n2 & 0x111) == 0) {
            return 0;
        }
        return com.uc.crashsdk.a.a(string, n, n2);
    }

    public int addCachedInfo(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        return com.uc.crashsdk.a.b(string, string2);
    }

    public int registerInfoCallback(String string, int n) {
        if (string == null) {
            throw new NullPointerException();
        }
        if ((n & 0x111) == 0) {
            return 0;
        }
        return com.uc.crashsdk.a.a(string, n, null, 0L, 0);
    }

    public int registerInfoCallback(String string, int n, Callable<String> callable) {
        if (string == null || callable == null) {
            throw new NullPointerException();
        }
        if ((n & 0x111) == 0) {
            return 0;
        }
        return com.uc.crashsdk.a.a(string, n, callable, 0L, 0);
    }

    public int addDumpFile(DumpFileInfo dumpFileInfo) {
        if (dumpFileInfo == null) {
            throw new NullPointerException();
        }
        if (dumpFileInfo.mCategory == null || dumpFileInfo.mFileTobeDump == null) {
            throw new NullPointerException();
        }
        if ((dumpFileInfo.mLogType & 0x111) == 0) {
            return 0;
        }
        return com.uc.crashsdk.a.a(dumpFileInfo.mCategory, dumpFileInfo.mFileTobeDump, dumpFileInfo.mIsEncrypted, dumpFileInfo.mWriteCategory, dumpFileInfo.mLogType, dumpFileInfo.mDeleteAfterDump);
    }

    public int addDumpFile(String string, String string2, int n, Bundle bundle) {
        DumpFileInfo dumpFileInfo = new DumpFileInfo(string, string2, n);
        if (bundle != null) {
            dumpFileInfo.mIsEncrypted = bundle.getBoolean("mIsEncrypted", dumpFileInfo.mIsEncrypted);
            dumpFileInfo.mWriteCategory = bundle.getBoolean("mWriteCategory", dumpFileInfo.mWriteCategory);
            dumpFileInfo.mDeleteAfterDump = bundle.getBoolean("mDeleteAfterDump", dumpFileInfo.mDeleteAfterDump);
        }
        return this.addDumpFile(dumpFileInfo);
    }

    public Throwable getUncaughtException() {
        return e.p();
    }

    public boolean updateUnexpInfo() {
        if (CrashApi.a("updateUnexpInfo")) {
            return false;
        }
        return com.uc.crashsdk.a.a(true);
    }

    public ParcelFileDescriptor getIsolatedHostFd() {
        if (CrashApi.a("getIsolatedHostFd")) {
            return null;
        }
        return e.w();
    }

    public boolean setIsolatedHostFd(ParcelFileDescriptor parcelFileDescriptor) {
        if (!com.uc.crashsdk.b.D()) {
            com.uc.crashsdk.a.a.b("crashsdk", "Cannot call setIsolatedHostFd in non-isolated process!");
            return false;
        }
        return e.a(parcelFileDescriptor);
    }

    private CrashApi(Context context, CustomInfo customInfo, VersionInfo versionInfo, ICrashClient iCrashClient, String string, boolean bl, boolean bl2, boolean bl3) {
        if (context == null) {
            com.uc.crashsdk.a.a.b("crashsdk", "context can not be null!");
            throw new NullPointerException();
        }
        if (!(context instanceof Application || (context = context.getApplicationContext()) != null && context instanceof Application)) {
            com.uc.crashsdk.a.a.b("crashsdk", "Can not get Application context from given context!");
            throw new IllegalArgumentException("Can not get Application context from given context!");
        }
        this.b = bl2;
        com.uc.crashsdk.b.g = bl3;
        if (com.uc.crashsdk.b.D()) {
            boolean bl4 = bl;
            ICrashClient iCrashClient2 = iCrashClient;
            VersionInfo versionInfo2 = versionInfo;
            CustomInfo customInfo2 = customInfo;
            Context context2 = context;
            CrashApi crashApi = this;
            CrashApi.a(context2, customInfo2, versionInfo2, iCrashClient2);
            if (bl4) {
                CrashApi.a();
            }
            if (crashApi.b && e.f("libcrashsdk.so")) {
                com.uc.crashsdk.b.f = true;
                crashApi.b();
            }
            return;
        }
        if (customInfo == null || versionInfo == null) {
            com.uc.crashsdk.a.a.b("crashsdk", "VersionInfo and CustomInfo can not be null!");
            throw new NullPointerException();
        }
        h.a(customInfo);
        try {
            e.a(string, true);
            CrashApi.a(context, customInfo, versionInfo, iCrashClient);
        }
        catch (Throwable throwable) {
            CrashApi.a(throwable);
        }
        try {
            if (bl) {
                CrashApi.a();
            }
        }
        catch (Throwable throwable) {
            CrashApi.a(throwable);
        }
        try {
            i.a();
            com.uc.crashsdk.a.h.a();
            com.uc.crashsdk.a.d.a();
            g.i();
        }
        catch (Throwable throwable) {
            g.a(throwable);
        }
        try {
            if (!com.uc.crashsdk.b.a(context)) {
                com.uc.crashsdk.a.a.b("crashsdk", "registerLifecycleCallbacks failed!");
            }
        }
        catch (Throwable throwable) {
            g.a(throwable);
        }
        try {
            com.uc.crashsdk.a.m();
            try {
                e.u();
            }
            catch (Throwable throwable) {
                g.b(throwable);
            }
            e.v();
        }
        catch (Throwable throwable) {
            g.a(throwable);
        }
        try {
            if (h.s() && com.uc.crashsdk.b.A()) {
                Context context3 = context;
                CrashApi crashApi = this;
                if (!crashApi.c) {
                    CrashLogFilesUploader.a(context3);
                    crashApi.c = true;
                }
            }
            return;
        }
        catch (Throwable throwable) {
            g.b(throwable);
            return;
        }
    }

    private static void a() {
        if (com.uc.crashsdk.b.a) {
            com.uc.crashsdk.a.a.c("Has enabled java log!");
            return;
        }
        e.n();
        e.k();
        com.uc.crashsdk.b.a = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b() {
        Object object = com.uc.crashsdk.b.e;
        synchronized (object) {
            if (!this.b || !com.uc.crashsdk.b.f) {
                return;
            }
            if (com.uc.crashsdk.b.b) {
                com.uc.crashsdk.a.a.c("Has enabled native log!");
                return;
            }
            CrashApi.c();
            int n = 0;
            if (com.uc.crashsdk.b.A()) {
                n = 1;
            } else if (com.uc.crashsdk.b.D()) {
                n = 2;
            }
            JNIBridge.nativeInstallBreakpad(n, 0);
            com.uc.crashsdk.b.b = true;
            JNIBridge.nativeBreakpadInited(Build.FINGERPRINT);
            h.e();
            return;
        }
    }

    private static void a(Context context, CustomInfo customInfo, VersionInfo versionInfo, ICrashClient iCrashClient) {
        CrashApi.a(context);
        com.uc.crashsdk.d.a(iCrashClient);
        h.a(customInfo, versionInfo);
        if (!com.uc.crashsdk.b.D()) {
            e.l();
            e.a(context);
        }
    }

    private static void a(Context context) {
        try {
            if (!d) {
                g.a(context);
                com.uc.crashsdk.a.a = context.getPackageName();
                d = true;
            }
            return;
        }
        catch (Throwable throwable) {
            CrashApi.a(throwable);
            return;
        }
    }

    private static void c() {
        if (com.uc.crashsdk.b.d) {
            return;
        }
        h.c();
        JNIBridge.nativeInitNative();
        h.d();
        com.uc.crashsdk.b.d = true;
    }

    private static void a(Throwable throwable) {
        new e().a(Thread.currentThread(), throwable, true);
    }

    private static boolean a(String string) {
        if (com.uc.crashsdk.b.D()) {
            com.uc.crashsdk.a.a.b("crashsdk", "Can not call '" + string + "' in isolated process!");
            return true;
        }
        return false;
    }
}

