package com.uc.crashsdk.tests.min_dependence;

import java.io.File;
import java.util.concurrent.Callable;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.webkit.ValueCallback;

import com.uc.crashsdk.export.CrashApi;

/**
 *
 * This sample is only import com.uc.crashsdk.export.CrashApi from crashsdk.
 *
 * Someone may use crashsdk with reflect classes and methods, only import
 * CrashApi will reduce the class and method reflect steps.
 *
 */
public class CrashWrapper {

    protected static final String TAG = "crashsdk";

    final public static boolean ENANBLE_JAVA_LOG   = true;
    final public static boolean ENABLE_NATIVE_LOG  = true;
    final public static boolean ENABLE_UNEXP_LOG   = false;

    public static boolean IS_DEBUG_VERSION = true;

    private static CrashApi sCrashApi = null;

    public static void initialize(Context context) {
        Log.i(TAG, "CrashWrapper_Bundle.initialize");
        final String url = "http://up4.ucweb.com:8012/upload";
        sCrashApi = CrashApi.createInstance(context, url, getParamInfo(context));
    }

    public static void uploadCrashLog() {
        Log.d(TAG, "uploadCrashLogs, server url: "
                + sCrashApi.getCrashLogUploadUrl());
        sCrashApi.uploadCrashLogs();
    }

    public static boolean generateCustomLog() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Any strings as you want write into the log from java.");

        // Parameters are the variables defined in CustomLogInfo as below.
        Bundle morePara = new Bundle();
        morePara.putBoolean("mAddHeader", true);
        morePara.putBoolean("mAddFooter", true);
        morePara.putBoolean("mAddLogcat", true);
        morePara.putBoolean("mUploadNow", false);
        return sCrashApi.generateCustomLog(buffer, "mytype", morePara);
    }

    // LogType constants value see LogType.java
    final static int LOG_NATIVE = 0x001;
    final static int LOG_JAVA   = 0x010;
    final static int LOG_NATIVE_JAVA = LOG_NATIVE | LOG_JAVA;

    public static void prepareCrashInfo(String soPath, boolean isNewInstall) {
        registerThread(null);

        // 1. TEST FOR info callback
        sCrashApi.registerInfoCallback("Callable Callback:",
                LOG_NATIVE_JAVA, new Callable<String>() {

            @Override
            public String call() {
                // The return string will be wrote into logs.
                return "test callback with Callable";
            }

        });

        // 2. TEST FOR callback event |onLogGenerated|
        // ICrashClient.EVENT_TYPE_LOG_GENERATED is 1
        final int LOG_GENERATED_EVENT = 1;
        sCrashApi.registerCallback(LOG_GENERATED_EVENT, new ValueCallback<Bundle>() {

            @Override
            public void onReceiveValue(Bundle paras) {
                // See the API document to get the parameters in |paras|
                String filePathName = paras.getString("filePathName");
                String logType = paras.getString("logType");

                Log.i(TAG, String.format("onLogGenerated with ValueCallback,"
                        + " file: %s, logType: %s", filePathName, logType));
            }

        });
    }

    public static void registerThread(String name) {
        sCrashApi.registerThread(LOG_NATIVE_JAVA, name);
    }

    public static void setNewInstall() { }
    public static void setForeground(boolean isForeground) { }
    public static boolean onExit() { return false; }
    public static void reportCrashStats() { }
    public static void resetCrashStats() { }

    //////////////////////////////////////////////////////////////////////////

    private static Bundle getParamInfo(Context context) {
        Bundle paras = new Bundle();
        // 1. support all member variables defined in CustomInfo
        paras.putBoolean("mZipLog", !IS_DEBUG_VERSION);
        paras.putBoolean("mDebugCrashSDK", IS_DEBUG_VERSION);
        paras.putBoolean("mBackupLogs", IS_DEBUG_VERSION);

        // 2. support all member variables defined in VersionInfo
        paras.putString("mVersion", "1.1");
        paras.putString("mSubVersion", "beta");
        paras.putString("mBuildSeq", "160107112233");

        // 3. enable logs
        paras.putBoolean("enableJavaLog", ENANBLE_JAVA_LOG);
        paras.putBoolean("enableNaiveLog", ENABLE_NATIVE_LOG);
        paras.putBoolean("enableUnexpLog", ENABLE_UNEXP_LOG);

        // 4. load so if needed.
        // If not add "soPathName", you need load the libcrashsdk.so by
        // your self.
        if (ENABLE_NATIVE_LOG) {
            File file = new File(context.getApplicationInfo().nativeLibraryDir,
                    "libcrashsdk.so");
            String path = file.getPath();
            paras.putString("soPathName", path);
        }
        return paras;
    }

}
