package com.uc.crashsdk.tests.logs_only;

import java.io.File;

import android.content.Context;
import android.util.Log;

import com.uc.crashsdk.export.CrashApi;
import com.uc.crashsdk.export.CustomInfo;
import com.uc.crashsdk.export.CustomLogInfo;
import com.uc.crashsdk.export.LogType;
import com.uc.crashsdk.export.VersionInfo;

/**
 *
 * This sample only shows how to generate java and native logs, and do not
 * use any other functions.
 *
 */
public class CrashWrapper {

    protected static final String TAG = "crashsdk";

    final public static boolean ENANBLE_JAVA_LOG   = true;
    final public static boolean ENABLE_NATIVE_LOG  = true;
    final public static boolean ENABLE_UNEXP_LOG   = false;

    private static CrashApi sCrashApi = null;

    public static void initialize(Context context) {
        Log.i(TAG, "CrashWrapper.initialize");
        final String url = "http://up4.ucweb.com:8012/upload";
        sCrashApi = CrashApi.createInstance(context, new CustomInfo(),
                getVersionInfo(), null, url,
                ENANBLE_JAVA_LOG, ENABLE_NATIVE_LOG, ENABLE_UNEXP_LOG);
    }

    public static void uploadCrashLog() {
        Log.d(TAG, "uploadCrashLogs, server url: "
                + sCrashApi.getCrashLogUploadUrl());
        sCrashApi.uploadCrashLogs();
    }

    public static void prepareCrashInfo(String soPath, boolean isNewInstall) {
        final boolean needLoadCrashsdkSo = ENABLE_NATIVE_LOG;

        if (needLoadCrashsdkSo) {
            // NOTICE: some service process may not need native log,
            // and no need load libcrashsdk.so.
            loadCrashsdkSo(soPath);

            if (ENABLE_NATIVE_LOG) {
                Log.v(TAG, "crashSoLoaded");
                sCrashApi.crashSoLoaded();

                registerThread(null);
            }
        }
    }

    public static boolean generateCustomLog() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Any strings as you want write into the log from java.");
        CustomLogInfo info = new CustomLogInfo(buffer, "mytype");

        return sCrashApi.generateCustomLog(info);
    }

    public static void registerThread(String name) {
        sCrashApi.registerThread(LogType.NATIVE | LogType.JAVA, name);
    }

    public static void setNewInstall() { }
    public static void setForeground(boolean isForeground) { }
    public static boolean onExit() { return false; }
    public static void reportCrashStats() { }
    public static void resetCrashStats() { }

    //////////////////////////////////////////////////////////////////////////

    private static void loadCrashsdkSo(String path) {
        File file = new File(path, "libcrashsdk.so");
        if (file.exists()) {
            System.load(file.getPath());
        } else {
            System.loadLibrary("crashsdk");
        }
    }

    private static VersionInfo getVersionInfo() {
        VersionInfo info = new VersionInfo();

        info.mVersion    = "1.0.0.1";
        info.mSubVersion = "beta";
        info.mBuildSeq   = "150102001122"; // suggested as "yymmddHHmmss"

        return info;
    }

}
