package com.uc.crashsdk.tests;

import java.io.File;
import java.io.IOException;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

public class TestReceiver extends BroadcastReceiver {

    protected static final String TAG = "crashsdk";

    public static final String NEW_INSTALL_FILE = "NewInstall";
    public static final String STARTED_FILE     = "HasStarted";

    @Override
    public void onReceive(Context context, Intent intent) {
        final String action = intent.getAction();
        Log.v(TAG, "ReceiverTest, action: " + action);

        if (Intent.ACTION_PACKAGE_ADDED.equals(action)
                || Intent.ACTION_PACKAGE_REPLACED.equals(action)) {
            String myPackageName = context.getPackageName();
            String pkgName = intent.getDataString().replace("package:", "");

            Log.v(TAG, "ReceiverTest, my: " + myPackageName
                    + ", change: " + pkgName);

            if (myPackageName.equals(pkgName)) {
                Log.v(TAG, "CrashAPI.setNewInstall");
                CrashWrapperSelector.setNewInstall();

                // For the application received this message but not start
                // activity, and killed by the system in the background. At
                // this case, the last exit type of the application may be
                // regard as background un-excepted crash.
                // So, create tag files "NewInstall" and "HasStarted"
                // to fix this.
                String filePathName = context.getApplicationInfo().dataDir + "/" + NEW_INSTALL_FILE;
                File f = new File(filePathName);
                if (!f.exists()) {
                    try {
                        f.createNewFile();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

}
