package com.uc.crashsdk.tests;

import android.content.Context;

import com.uc.crashsdk.tests.standard.CrashWrapper;
//import com.uc.crashsdk.tests.native_api.CrashWrapper;
//import com.uc.crashsdk.tests.logs_only.CrashWrapper;
//import com.uc.crashsdk.tests.min_dependence.CrashWrapper;

public class CrashWrapperSelector {

    final public static boolean ENANBLE_JAVA_LOG  = CrashWrapper.ENANBLE_JAVA_LOG;
    final public static boolean ENABLE_NATIVE_LOG = CrashWrapper.ENABLE_NATIVE_LOG;
    final public static boolean ENABLE_UNEXP_LOG  = CrashWrapper.ENABLE_UNEXP_LOG;

    public static void initialize(Context context) {
        CrashWrapper.initialize(context);
    }

    public static void setNewInstall() {
        CrashWrapper.setNewInstall();
    }

    public static void uploadCrashLog() {
        CrashWrapper.uploadCrashLog();
    }

    public static void setForeground(boolean isForeground) {
        CrashWrapper.setForeground(isForeground);
    }

    public static boolean onExit() {
        return CrashWrapper.onExit();
    }

    public static void registerThread(String name) {
        CrashWrapper.registerThread(name);
    }

    public static void prepareCrashInfo(String soPath, boolean isNewInstall) {
        CrashWrapper.prepareCrashInfo(soPath, isNewInstall);
    }

    public static void reportCrashStats() {
        CrashWrapper.reportCrashStats();
    }

    public static void resetCrashStats() {
        CrashWrapper.resetCrashStats();
    }

    public static boolean generateCustomLog() {
        return CrashWrapper.generateCustomLog();
    }

}
