# by shijiang.ysj@alibaba-inc.com
# 2016-03-01

LOCAL_PATH      := $(realpath $(call my-dir)/..)
DEPENDS_PATH    := $(LOCAL_PATH)/..

#####################################################################################
#                                                                                   #
#                                  libnativetest.so                                 #
#                                                                                   #
#####################################################################################
include $(CLEAR_VARS)

LOCAL_MODULE := nativetest

LOCAL_CFLAGS += -funwind-tables
LOCAL_CFLAGS += -fno-stack-protector
LOCAL_CFLAGS += -fno-rtti

LOCAL_CFLAGS += -Werror=uninitialized
LOCAL_CFLAGS += -Werror=missing-braces
LOCAL_CFLAGS += -Werror=char-subscripts
LOCAL_CFLAGS += -Werror=return-type
LOCAL_CFLAGS += -Werror=multichar
LOCAL_CFLAGS += -Werror=sequence-point
LOCAL_CFLAGS += -Werror=strict-aliasing
LOCAL_CFLAGS += -Werror=comment
LOCAL_CFLAGS += -Werror=parentheses
LOCAL_CFLAGS += -Werror=unused


LOCAL_C_INCLUDES += $(LOCAL_PATH)               \
                    $(LOCAL_PATH)/src           \
                    $(LOCAL_PATH)/include

LOCAL_SRC_FILES_test := src/JNIRegisterTest.cpp

d := .
LOCAL_SRC_FILES += $(addprefix $d/,$(LOCAL_SRC_FILES_test))

LOCAL_LDFLAGS += -Wl,--gc-sections

LOCAL_LDLIBS +=  -llog

# link with libcrashsdk.so
LOCAL_LDLIBS +=  -L$(call host-path,$(DEPENDS_PATH))/libs/$(TARGET_ARCH_ABI) -lcrashsdk

# if libcrashsdk.so is located in current project's libs/$(TARGET_ARCH_ABI), use:
#LOCAL_SHARED_LIBRARIES += -lcrashsdk

include $(BUILD_SHARED_LIBRARY)
